define(['app', 'angular'], function (app, angular) {
	'use strict';

	app.config(function ($provide) {
		$provide.decorator('ngClickDirective', function($delegate) {
		   	var original = $delegate[0],
		   	    compile = original.compile;

		    original.compile = function() {
		      var link = compile.apply(this, arguments);

		      return function(scope, element, attrs) {
		        link.apply(this, arguments);
		        if(attrs.noClickDecoration != "true"){
		        	!attrs.tabindex && attrs.$set("tabindex", 0);

	                if(element[0].tagName !== "BUTTON") {

	                	if(!(attrs.role || attrs.href)) {
	                		attrs.$set("role", "button");
	                	}

	                    element.bind('keypress', function (event) {
	                        if(event.keyCode === 13 || event.keyCode === 32) {
	                            scope.$eval(attrs.ngClick);
	                        }
	                    });

	                    scope.$on("$destroy", function(){
	                        element.unbind("keypress");
	                    });
	                } 
            	}
		      };
		    };
			return $delegate;
		});
	});
});